/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.dialog.comp.Measurement;
import DE.siemens.ad.logo.model.Analog;
import DE.siemens.ad.logo.model.AnalogOrBlockReference;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.HardwareChangedEvent;
import DE.siemens.ad.logo.model.IntegerOrBlockReference;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.model.Seconds;
import DE.siemens.ad.logo.model.Timer;
import DE.siemens.ad.logo.util.AnalogValueProperties;
import DE.siemens.ad.logo.util.IntValueProperties;
import DE.siemens.ad.logo.util.Util;
import java.io.IOException;

public class RampControlParameter
extends Analog {
    static final long serialVersionUID = 136171616738026713L;
    private int blockParameterSerializedDataVersion = 1;
    private AnalogValueProperties fRate;
    private AnalogOrBlockReference fRamp1;
    private AnalogOrBlockReference fRamp2;
    private AnalogValueProperties fMaxOutput;
    private Timer fTimer;
    private AnalogValueProperties fStartStopOffset;
    private static final int INIT = 0;
    private static final int DECELERATED_STOP = 1;
    private static final int RAMP_STOP = 2;
    private static final int RAMP = 3;
    private transient boolean fLastStop;
    private transient boolean fLastEnable;
    private transient long fLastSystemTime;
    private transient double fCurrentRateSum;
    private transient AnalogValueProperties fCurrentLevelProperties;

    public RampControlParameter() {
        this.getMeasurement().getSensor().getAnalogCalculationMethod().setMinGain(0);
    }

    public RampControlParameter(Block block) {
        super(block);
        this.getMeasurement().getSensor().getAnalogCalculationMethod().setMinGain(0);
    }

    public String calculateCurrentParameterText() {
        String value = Util.addTrailingSpaces(Integer.toString(this.fAmplifiedX), 6);
        value = "Current level = " + value + "\nAQ = " + this.getOutputFromAmplifiedValue();
        return value;
    }

    public String getParameterText() {
        StringBuffer buffer = new StringBuffer(super.getParameterText());
        if (buffer.length() > 0) {
            buffer.append("\n");
        }
        buffer.append("Gain  =").append(this.getGainString()).append(this.getProtectionSign()).append("\nOffset=").append(this.getOffset()).append("\nPoint =").append(this.getDecimalPlace()).append(super.getParameterText()).append("\nRate=").append(this.getRate().getCurrentValue()).append(this.getProtectionSign()).append("\nMaxL=").append(this.getMaxOutput().getCurrentValue()).append("\nStSp=").append(this.getStartStopOffset().getCurrentValue()).append("\nL1=").append(this.getRamp1().getParameterText()).append("\nL2=").append(this.getRamp2().getParameterText());
        return buffer.toString();
    }

    public AnalogValueProperties getRate() {
        if (this.fRate == null) {
            this.fRate = new AnalogValueProperties(1, 10000, 1, 10, 0, "error.ramp.rate", "Wrong ramp.");
        }
        this.fRate.setDecimalPlace(this.getDecimalPlace());
        return this.fRate;
    }

    public void setRate(IntValueProperties rate) {
        this.fRate.setCurrentValue(rate.getCurrentValue());
    }

    public void setRate(AnalogValueProperties rate) {
        this.fRate.setCurrentValue(rate.getCurrentValue());
    }

    public IntValueProperties getMaxOutput() {
        if (this.fMaxOutput == null) {
            this.fMaxOutput = new AnalogValueProperties(-10000, 20000, 1, 1000, 0, true, "error.ramp.maxAQ", "Wrong AQ.");
        }
        this.fMaxOutput.setDecimalPlace(this.getDecimalPlace());
        return this.fMaxOutput;
    }

    public void setMaxOutput(IntValueProperties maxOutput) {
        this.fMaxOutput.setCurrentValue(maxOutput.getCurrentValue());
    }

    public IntValueProperties getStartStopOffset() {
        if (this.fStartStopOffset == null) {
            this.fStartStopOffset = new AnalogValueProperties(0, 20000, 1, 0, 0, true, "error.ramp.startStop", "Wrong StartStopValue.");
        }
        this.fStartStopOffset.setDecimalPlace(this.getDecimalPlace());
        return this.fStartStopOffset;
    }

    public void setStartStopOffset(IntValueProperties startStopValue) {
        this.fStartStopOffset.setCurrentValue(startStopValue.getCurrentValue());
    }

    public AnalogOrBlockReference getRamp1() {
        if (this.fRamp1 == null) {
            this.fRamp1 = new AnalogOrBlockReference(this);
            this.fRamp1.setAnalogValueProperties(new AnalogValueProperties(-10000, 20000, 1, 0, 0, true, "error.ramp.ramp1", "Wrong Ramp1"));
        }
        this.fRamp1.setDecimalPlace(this.getDecimalPlace());
        return this.fRamp1;
    }

    public void setRamp1(IntegerOrBlockReference ramp) {
        this.fRamp1.setValue(ramp);
    }

    public void setRamp1(AnalogOrBlockReference ramp) {
        this.fRamp1.setValue(ramp);
    }

    public AnalogOrBlockReference getRamp2() {
        if (this.fRamp2 == null) {
            this.fRamp2 = new AnalogOrBlockReference(this);
            this.fRamp2.setAnalogValueProperties(new AnalogValueProperties(-10000, 20000, 1, 0, 0, true, "error.ramp.ramp2", "Wrong Ramp2"));
        }
        this.fRamp2.setDecimalPlace(this.getDecimalPlace());
        return this.fRamp2;
    }

    public void setRamp2(IntegerOrBlockReference ramp) {
        this.fRamp2.setValue(ramp);
    }

    public void setRamp2(AnalogOrBlockReference ramp) {
        this.fRamp2.setValue(ramp);
    }

    public double getAnalogValue(boolean enable, boolean selector, boolean stop) {
        double result = this.calculateAnalogValue(enable, selector, stop);
        this.fCurrentParameterText = this.calculateCurrentParameterText();
        this.fireParameterUpdateEvent();
        return result;
    }

    public double calculateAnalogValue(boolean enable, boolean selector, boolean stop) {
        double result = this.getOutputFromAmplifiedValue();
        if (enable) {
            if (!this.fLastEnable) {
                this.fLastEnable = true;
                this.fState = !stop ? 0 : 1;
            } else if (stop && !this.fLastStop) {
                this.fState = 1;
            }
        } else {
            this.fState = 2;
            if (!stop) {
                this.fLastEnable = false;
            }
        }
        int maxOutput = this.calculateMaxOutput();
        switch (this.fState) {
            case 0: {
                this.fAmplifiedX = this.getOffset() + this.getStartStopOffset().getCurrentValue();
                if (this.fAmplifiedX > maxOutput) {
                    this.fAmplifiedX = maxOutput;
                }
                result = this.getOutputFromAmplifiedValue();
                this.fState = 3;
                this.getTimer().start();
                this.fLastSystemTime = this.getSystemTime();
                break;
            }
            case 1: {
                long currentTime = this.getSystemTime();
                long pastDecelTime = currentTime - this.fLastSystemTime;
                if (this.fAmplifiedX == this.getOffset() || pastDecelTime <= 100L) break;
                this.fLastSystemTime = currentTime;
                int destinationSpeed = this.getOffset() + this.getStartStopOffset().getCurrentValue();
                if (destinationSpeed > maxOutput) {
                    destinationSpeed = maxOutput;
                }
                double currentDecelRate = (double)this.getRate().getCurrentValue() / (10.0 * (double)pastDecelTime / 100.0);
                this.fCurrentRateSum += currentDecelRate;
                if (this.fCurrentRateSum > 1.0) {
                    currentDecelRate = (int)this.fCurrentRateSum;
                    this.fCurrentRateSum -= currentDecelRate;
                } else {
                    currentDecelRate = 0.0;
                }
                if (this.fAmplifiedX <= destinationSpeed) {
                    this.fAmplifiedX = this.getOffset();
                    result = this.getOutputFromAmplifiedValue();
                    break;
                }
                this.fAmplifiedX = (int)((double)this.fAmplifiedX - currentDecelRate);
                if (this.fAmplifiedX >= destinationSpeed) break;
                this.fAmplifiedX = destinationSpeed;
                result = this.getOutputFromAmplifiedValue();
                break;
            }
            case 3: {
                int destinationSpeed;
                long currentTime = this.getSystemTime();
                long pastRampTime = currentTime - this.fLastSystemTime;
                if (pastRampTime <= 100L) break;
                this.fLastSystemTime = currentTime;
                int n = destinationSpeed = !selector ? this.fRamp1.getValue() : this.fRamp2.getValue();
                if (destinationSpeed > maxOutput) {
                    destinationSpeed = maxOutput;
                } else if (destinationSpeed < this.getOffset()) {
                    destinationSpeed = this.getOffset();
                }
                if (this.fAmplifiedX == destinationSpeed) break;
                double currentRampRate = (double)this.getRate().getCurrentValue() / 10.0 * (double)pastRampTime / 100.0;
                this.fCurrentRateSum += currentRampRate;
                if (this.fCurrentRateSum > 1.0) {
                    currentRampRate = (int)this.fCurrentRateSum;
                    this.fCurrentRateSum -= currentRampRate;
                } else {
                    currentRampRate = 0.0;
                }
                if (this.fAmplifiedX < destinationSpeed) {
                    this.fAmplifiedX = (int)((double)this.fAmplifiedX + currentRampRate);
                    if (this.fAmplifiedX > destinationSpeed) {
                        this.fAmplifiedX = destinationSpeed;
                    }
                } else {
                    this.fAmplifiedX = (int)((double)this.fAmplifiedX - currentRampRate);
                    if (this.fAmplifiedX < destinationSpeed) {
                        this.fAmplifiedX = destinationSpeed;
                    }
                }
                result = this.getOutputFromAmplifiedValue();
                break;
            }
            case 2: {
                this.fAmplifiedX = this.getOffset();
                result = this.getOutputFromAmplifiedValue();
                break;
            }
        }
        this.fLastStop = stop;
        return result;
    }

    private double getOutputFromAmplifiedValue() {
        int offset = this.fMeasurement.getOffset();
        int gain = this.fMeasurement.getGain();
        if (this.fAmplifiedX == offset || gain == 0) {
            return 0.0;
        }
        return Math.min(Short.MAX_VALUE, this.fMeasurement.getAnalogCalculationMethod().calculateInternalValue(this.fAmplifiedX, gain, offset));
    }

    public AnalogValueProperties getCurrentLevel() {
        if (this.fCurrentLevelProperties == null) {
            this.fCurrentLevelProperties = new AnalogValueProperties(MIN_TRIGGER, MAX_TRIGGER, 1, this.fAmplifiedX, this.getDecimalPlace(), this.isAnalogValueDecimalPlacesAvailable(), "error.dialog.invalidValue", "Invalid Value");
        }
        this.fCurrentLevelProperties.setCurrentValue(this.fAmplifiedX);
        this.fCurrentLevelProperties.setDecimalPlace(this.getDecimalPlace());
        return this.fCurrentLevelProperties;
    }

    private long getSystemTime() {
        return this.fInterpreter.getCurrentSimulationTimerTime();
    }

    private int calculateMaxOutput() {
        int offset;
        int maxOutput = this.fMaxOutput.getCurrentValue();
        return maxOutput >= (offset = this.fMeasurement.getOffset()) ? maxOutput : offset;
    }

    public Timer getTimer() {
        if (this.fTimer == null) {
            this.fTimer = new Timer(new Seconds().setTime(100));
        }
        return this.fTimer;
    }

    public void init(Interpreter interpreter, boolean forceReset) {
        super.init(interpreter, forceReset);
        this.getTimer().init(interpreter);
        this.fLastEnable = false;
        this.fLastStop = false;
        this.fState = 0;
        this.fCurrentRateSum = 0.0;
        this.fLastSystemTime = 0L;
    }

    public AnalogValueProperties getAmplifiedAQ() {
        if (this.fAmplifiedXProperties == null) {
            this.fAmplifiedXProperties = new AnalogValueProperties(MIN_TRIGGER, MAX_TRIGGER, 1, (int)this.fXInput, this.getDecimalPlace(), this.isAnalogValueDecimalPlacesAvailable(), "error.dialog.invalidValue", "Invalid Value");
        }
        this.fAmplifiedXProperties.setCurrentValue((int)Math.round(this.getOutputFromAmplifiedValue()));
        this.fAmplifiedXProperties.setDecimalPlace(this.getDecimalPlace());
        return this.fAmplifiedXProperties;
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable(this.fMaxOutput);
        dw.writeStorable(this.fRamp1);
        dw.writeStorable(this.fRamp2);
        dw.writeStorable(this.fRate);
        dw.writeStorable(this.fStartStopOffset);
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fMaxOutput = (AnalogValueProperties)dr.readStorable();
        this.fRamp1 = (AnalogOrBlockReference)dr.readStorable();
        this.fRamp2 = (AnalogOrBlockReference)dr.readStorable();
        this.fRate = (AnalogValueProperties)dr.readStorable();
        this.fStartStopOffset = (AnalogValueProperties)dr.readStorable();
    }

    public void hardwareChanged(HardwareChangedEvent hardwareChangedEvent) {
        this.getMeasurement().setAnalogCalculationMethod(new Measurement.AnalogCalculation0BA4());
        this.getAmplifiedXProperties().setSuppressLeadingZeroes(this.isAnalogValueDecimalPlacesAvailable());
        this.fireParameterSetEvent();
    }
}

